<x-app-layout>
<div class="py-12 max-w-7xl mx-auto">
 
    @if(session('success'))
        <div class="mb-4 p-3 bg-green-100 text-green-800 rounded">
            {{ session('success') }}
        </div>
    @endif
    
 
    <form method="GET" action="{{ url('admin/users') }}" class="mb-4 flex space-x-2">
        <input type="text" name="search" value="{{ request('search') }}"
               placeholder="Search by User..."
               class="flex-1 border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 rounded px-3 py-2 focus:outline-none focus:ring-2 focus:ring-indigo-500">

        <button type="submit" 
                class="px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700">
            Search
        </button>
    </form>
        

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($users as $user)
            <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-6">
                <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-200">
                    {{ $user->name }}
                </h3>
                <p class="text-sm text-gray-500">{{ $user->email }}</p>
                
                <div class="mt-3">
                    <p class="text-sm font-medium text-gray-600 dark:text-gray-400">Wallet Balance</p>
                    <p class="text-xl font-bold text-green-600">${{ $user->wallet_balance }}</p>
                </div>

                <!-- Wallet Top-up Form -->
                <form action="{{ route('admin.users.wallet.add', $user->id) }}" method="POST" class="mt-4 flex space-x-2">
                    @csrf
                    <input type="number" step="0.01" name="amount" placeholder="Amount" 
                           class="w-full border rounded p-2 text-sm">
                    <button type="submit" 
                            class="bg-green-600 text-white px-4 py-2 rounded text-sm hover:bg-green-700">
                        Add
                    </button>
                </form>

                <!-- Action Buttons -->
                <div class="mt-4 flex space-x-2">
                    <!-- Edit -->
                  <form action='{{ url("admin/users/{$user->id}/block") }}'  method="POST" class="flex-1">
        @csrf
        <button type="submit" 
                class="w-full {{ $user->is_blocked ? 'bg-yellow-600 hover:bg-yellow-700' : 'bg-gray-600 hover:bg-gray-700' }} text-white text-sm px-3 py-2 rounded">
            {{ $user->is_blocked ? 'Unblock' : 'Block' }}
        </button>
    </form>

                    <!-- Delete -->
                    <form action="{{ url('admin/users', $user->id) }}" method="POST" 
                          onsubmit="return confirm('Are you sure you want to delete this user?')" 
                          class="flex-1">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                class="w-full bg-red-600 text-white text-sm px-3 py-2 rounded hover:bg-red-700">
                            Remove
                        </button>
                    </form>
                </div>
            </div>
        @endforeach
    </div>

    <div class="mt-6">
        {{ $users->links() }}
    </div>
</div>
</x-app-layout>
