<x-app-layout>



<div class="flex flex-col lg:flex-row gap-4 py-12 max-w-7xl mx-auto">
  <div class="w-full lg:w-[30%]">
 
<div class=" max-w-3xl mx-auto">
    <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6">
        <h2 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-4">Add Product Price</h2>

        @if(session('success'))
            <div class="mb-4 text-light p-3 rounded bg-green-100 text-green-800">
                {{ session('success') }}
            </div>
        @endif

        <form action="{{ route('product-prices.store') }}" method="POST" class="space-y-4">
            @csrf

         
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Select Product</label>
                <select name="product_id" class="w-full border-gray-300 dark:border-gray-700 rounded-md">
                    <option value="">-- Select --</option>
                    @foreach($products as $product)
                        <option value="{{ $product->id }}">{{ $product->name }}</option>
                    @endforeach
                </select>
                @error('product_id')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

           
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Duration (Days)</label>
                <input type="number" name="duration" class="w-full border-gray-300 dark:border-gray-700 rounded-md" placeholder="e.g. 30">
                @error('duration')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
 
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Price ($)</label>
                <input type="number" step="0.01" name="price" class="w-full border-gray-300 dark:border-gray-700 rounded-md" placeholder="e.g. 499">
                @error('price')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

           <br> 
            <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-700">
                Add Price
            </button>
        </form>
    </div>
</div>
</div>
  <div class="w-full lg:w-[60%]">
  <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                
                    
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
         Total Product Price
        </h2>
        <br>
        <table class="min-w-full border border-gray-300 table-auto">
                    <thead>
                        <tr class="bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-200">
                            <th class="border p-2">#</th>
                            <th class="border p-2">Product</th>
                            <th class="border p-2">Duration (Days)</th>
                            <th class="border p-2">Price ($)</th>
                            <th class="border p-2">Created At</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($prices as $price)
                            <tr>
                                <td class="border p-2">{{ $price->id }}</td>
                                <td class="border p-2">{{ $price->product->name ?? '-' }}</td>
                                <td class="border p-2">{{ $price->duration }}</td>
                                <td class="border p-2">${{ number_format($price->price, 2) }}</td>
                                <td class="border p-2">{{ $price->created_at }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center p-4 text-gray-500">No product prices found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                </div>
            </div>
  </div>
</div>

    </div>
</x-app-layout>
