<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\User\WalletTransactionController;
use App\Http\Controllers\User\OrderController;
use App\Http\Controllers\User\GenerateKeyController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});
Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::middleware(['auth'])->group(function () {
 

    Route::middleware(['isAdmin'])->group(function () {
         Route::prefix('admin/users')->name('admin.users.')->group(function () {
    Route::get('/', [UserController::class, 'index'])->name('index');
    Route::get('/{id}/edit', [UserController::class, 'edit'])->name('edit');
    Route::put('/{id}', [UserController::class, 'update'])->name('update');
    Route::delete('destroy/{id}', [UserController::class, 'destroy'])->name('destroy');
    Route::post('/{id}/wallet', [UserController::class, 'addWallet'])->name('wallet.add');
});

Route::post('/admin/users/{id}/block', [\App\Http\Controllers\UserController::class, 'toggleBlock'])->name('admin.users.block');

Route::get('/admin/dashboard',[AdminController::class,'index'])->name('admin.dashboard');

Route::get('/admin/product',[ProductController::class,'index'])->name('products.index');
Route::post('/admin/product/store',[ProductController::class,'store'])->name('products.store');
Route::get('/products/{product}/edit', [ProductController::class, 'edit'])->name('products.edit');
Route::put('/products/{product}', [ProductController::class, 'update'])->name('products.update');
Route::delete('/products/{product}', [ProductController::class, 'destroy'])->name('products.destroy');

Route::post('/keys/import', [KeyImportController::class, 'import'])->name('keys.import');

    Route::match(['get','post'],'/admin/order-history',[App\Http\Controllers\OrderController::class,'index'])->name('admin.order-history');


Route::match(['get','post'], '/admin/generate-key', [AdminController::class, 'key'])
    ->name('admin.generate-key');

Route::get('/wallet-transactions',[WalletController::class,'walletTransactions'])->name('admin.wallet-transactions');
Route::get('/product-prices/create', [ProductPriceController::class, 'create'])->name('product-prices.create');
Route::post('/product-prices', [ProductPriceController::class, 'store'])->name('product-prices.store');
Route::post('/keys', [AdminController::class, 'keystore'])->name('keys.store');

    Route::resource('admin/users', \App\Http\Controllers\UserController::class);
    Route::post('users/{user}/wallet', [\App\Http\Controllers\UserController::class, 'addWallet'])
        ->name('admin.users.wallet.add');
    
});
});


 
// User routes
 Route::middleware(['blockuser'])
    ->prefix('user')
    ->name('user.')
    ->group(function () {
        
        Route::get('/dashboard', function () {
            return view('user.dashboard');
        })->name('dashboard');

             Route::get('/order-history', [OrderController::class, 'index'])
            ->name('order-history');

        Route::resource('/keys', GenerateKeyController::class);

        Route::get('/wallet-transition', function () {
            return view('user.wallet');
        })->name('wallet-transaction');
        Route::get('/wallet-transactions',[WalletTransactionController::class,'walletTransactions'])->name('wallet-transactions');
        Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    });


require __DIR__.'/auth.php';
