@extends('user.layout')
@section('content')
<div class="py-12 max-w-7xl mx-auto">
    <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg p-6">
        <h2 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-4">
            Wallet Transactions
        </h2>

        <table class="table-auto w-full border-collapse border border-gray-300">
            <thead>
                <tr class="bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-200">
                    <th class="border p-2">Date</th>
                    <th class="border p-2">Type</th>
                    <th class="border p-2">Amount</th>
                    <th class="border p-2">Balance After</th>
                    <th class="border p-2">Description</th>
                </tr>
            </thead>
            <tbody>
                @forelse($transactions as $txn)
                    <tr>
                        <td class="border p-2">{{ $txn->created_at->format('d M Y H:i') }}</td>
                        <td class="border p-2 {{ $txn->type == 'credit' ? 'text-green-600' : 'text-red-600' }}">
                            {{ ucfirst($txn->type) }}
                        </td>
                        <td class="border p-2">${{ $txn->amount }}</td>
                        <td class="border p-2">${{ $txn->balance_after }}</td>
                        <td class="border p-2">{{ $txn->description }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center p-4 text-gray-500">No transactions found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>

        <div class="mt-4">
            {{ $transactions->links() }}
        </div>
    </div>
</div>
@endsection
