@extends('user.layout')

@section('content')

<div class="py-12 max-w-7xl mx-auto">
    <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg p-6">
        <h2 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-4">
            Order History
        </h2>
  <!-- 🔍 Search Form -->
        <form method="GET" action="{{ route('user.order-history') }}" class="mb-4 flex space-x-2">
            <input type="text" name="search" value="{{ request('search') }}"
                   placeholder="Search by Key..."
                   class="flex-1 border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 rounded px-3 py-2 focus:outline-none focus:ring-2 focus:ring-indigo-500">

            <button type="submit" 
                    class="px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700">
                Search
            </button>
        </form>
 
        <div class="hidden md:block overflow-x-auto">
            <table class="min-w-full table-auto border-collapse border border-gray-300">
                <thead>
                    <tr class="bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-200">
                        <th class="border p-2">Order ID</th>
                        <th class="border p-2">Product</th>
                        <th class="border p-2">Key</th>
                        <th class="border p-2">Duration</th>
                        <th class="border p-2">Price</th>
                        <th class="border p-2">Date</th>
                        <th class="border p-2">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($orders as $order)
      
                        <tr>
                            <td class="border p-2 whitespace-nowrap">#{{ $order->id }}</td>
                            <td class="border p-2 whitespace-nowrap">{{ $order->product->name ?? '-' }}</td>
                            <td class="border p-2 whitespace-nowrap">{{ $order->key->decrypted_key ?? 'N/A' }} <button  onclick="copyToClipboard('{{ $order->key->decrypted_key }}')" 
                            class="ml-2  pt-2 border-none">
                   <svg xmlns="http://www.w3.org/2000/svg" width="20" viewBox="0 0 640 640"><!--!Font Awesome Free v7.0.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="#4f46e5" d="M288 64C252.7 64 224 92.7 224 128L224 384C224 419.3 252.7 448 288 448L480 448C515.3 448 544 419.3 544 384L544 183.4C544 166 536.9 149.3 524.3 137.2L466.6 81.8C454.7 70.4 438.8 64 422.3 64L288 64zM160 192C124.7 192 96 220.7 96 256L96 512C96 547.3 124.7 576 160 576L352 576C387.3 576 416 547.3 416 512L416 496L352 496L352 512L160 512L160 256L176 256L176 192L160 192z"/></svg>
                    </button></td>
                            <td class="border p-2 whitespace-nowrap">{{ $order->duration ?? '-' }} Days</td>
                            <td class="border p-2 whitespace-nowrap">₹{{ $order->total_price }}</td>
                            <td class="border p-2 whitespace-nowrap">{{ $order->created_at->format('d M Y H:i') }}</td>
                            <td class="border p-2 whitespace-nowrap">
                                <span class="px-2 py-1 rounded text-white 
                                    {{ $order->status == 'completed' ? 'bg-green-500' : 'bg-yellow-500' }}">
                                    {{ ucfirst($order->status) }}
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center p-4 text-gray-500">No orders found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

  
        <div class="block md:hidden space-y-4">
            @forelse($orders as $order)
     
                <div class="border border-gray-300 dark:border-gray-700 rounded-lg p-4 bg-gray-50 dark:bg-gray-900">
                    <div class="flex justify-between items-center">
                        <h3 class="text-sm font-semibold text-gray-700 dark:text-gray-300">
                            Order #{{ $order->id }}
                        </h3>
                        <span class="px-2 py-1 text-xs rounded text-white 
                            {{ $order->status == 'completed' ? 'bg-green-500' : 'bg-yellow-500' }}">
                            {{ ucfirst($order->status) }}
                        </span>
                    </div>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-2">
                        <strong>Product:</strong> {{ $order->product->name ?? '-' }}
                    </p>
                    <p class="text-sm text-gray-600 dark:text-gray-400">
                        <strong>Key:</strong> {{ $order->key->decrypted_key ?? 'N/A' }} <button  onclick="copyToClipboard('{{ $order->key->decrypted_key }}')" 
                            class="ml-2  pt-2 border-none">
                   <svg xmlns="http://www.w3.org/2000/svg" width="20" viewBox="0 0 640 640"><!--!Font Awesome Free v7.0.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="#4f46e5" d="M288 64C252.7 64 224 92.7 224 128L224 384C224 419.3 252.7 448 288 448L480 448C515.3 448 544 419.3 544 384L544 183.4C544 166 536.9 149.3 524.3 137.2L466.6 81.8C454.7 70.4 438.8 64 422.3 64L288 64zM160 192C124.7 192 96 220.7 96 256L96 512C96 547.3 124.7 576 160 576L352 576C387.3 576 416 547.3 416 512L416 496L352 496L352 512L160 512L160 256L176 256L176 192L160 192z"/></svg>
                    </button>
                    </p>
                    <p class="text-sm text-gray-600 dark:text-gray-400">
                        <strong>Duration:</strong> {{ $order->duration ?? '-' }} Days
                    </p>
                    <p class="text-sm text-gray-600 dark:text-gray-400">
                        <strong>Price:</strong> ${{ $order->total_price }}
                    </p>
                    <p class="text-sm text-gray-600 dark:text-gray-400">
                        <strong>Date:</strong> {{ $order->created_at->format('d M Y H:i') }}
                    </p>
                </div>
            @empty
                <p class="text-center p-4 text-gray-500">No orders found</p>
            @endforelse
        </div>

        <div class="mt-4">
            {{ $orders->links() }}
        </div>
    </div>
</div>
<script>
function calculateTotal() {
    let price = parseFloat(document.querySelector("#keySelect option:checked")?.dataset.price || 0);
    let qty = parseInt(document.getElementById("quantitySelect")?.value || 1);
    document.getElementById("totalPrice").innerText = price * qty;
}

document.getElementById("keySelect")?.addEventListener("change", calculateTotal);
document.getElementById("quantitySelect")?.addEventListener("change", calculateTotal);
window.onload = calculateTotal;
</script>
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert("Key copied to clipboard!");
    });
}
</script>
@endsection
