<nav x-data="{ open: false }" class="dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700">
 
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
           
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('user.dashboard') }}">
                        <x-application-logo class="block h-9 w-auto fill-current text-gray-800 dark:text-gray-200" />
                    </a>
                </div>

              
                <!--<div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">-->
                <!--    <x-nav-link :href="route('user.dashboard')" :active="request()->routeIs('admin.dashboard')">-->
                <!--        {{ __('Dashboard') }}-->
                <!--    </x-nav-link>-->
                <!--</div>-->
 
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="url('user/keys')" :active="request()->routeIs('user.keys.*')">
                        {{ __('Generate Key') }}
                    </x-nav-link>
                </div>

                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('user.order-history')" :active="request()->routeIs('user.order-history')">
                        {{ __('Order History') }}
                    </x-nav-link>
                </div>

                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('user.wallet-transactions')" :active="request()->routeIs('user.wallet-transactions')">
                        {{ __('Wallet Transactions') }}
                    </x-nav-link>
                </div>
            </div>
 
           
            <div class="hidden sm:flex sm:items-center sm:ms-6 space-x-4">
 
<div class="flex items-center space-x-2 text-gray-700 dark:text-gray-300">
      <p class="text-sm font-semibold">Wallet: 💰 $ {{ auth()->user()->wallet_balance }}</p>
      
    <!-- <svg class="h-6 w-6 text-gray-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
        <path fill="#9ca3af" d="M128 96C92.7 96 64 124.7 64 160L64 448C64 483.3 92.7 512 128 512L512 512C547.3 512 576 483.3 576 448L576 256C576 220.7 547.3 192 512 192L136 192C122.7 192 112 181.3 112 168C112 154.7 122.7 144 136 144L520 144C533.3 144 544 133.3 544 120C544 106.7 533.3 96 520 96L128 96zM480 320C497.7 320 512 334.3 512 352C512 369.7 497.7 384 480 384C462.3 384 448 369.7 448 352C448 334.3 462.3 320 480 320z"/>
    </svg>
    
    <span style="margin-right:10px;margin-left: 5px;" class="font-semibold">{{Auth::user()->wallet_balance}}</span> -->
</div>

 

    
              <x-dropdown align="right" width="64">
    <x-slot name="trigger">
        <div style="cursor:pointer" class="relative inline-flex items-center p-2 text-gray-500 dark:text-gray-400 dark:hover:text-gray-300 focus:outline-none transition">
            <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                <path fill="#9ca3af" d="M320 64C306.7 64 296 74.7 296 88L296 97.7C214.6 109.3 152 179.4 152 264L152 278.5C152 316.2 142 353.2 123 385.8L101.1 423.2C97.8 429 96 435.5 96 442.2C96 463.1 112.9 480 133.8 480L506.2 480C527.1 480 544 463.1 544 442.2C544 435.5 542.2 428.9 538.9 423.2L517 385.7C498 353.1 488 316.1 488 278.4L488 263.9C488 179.3 425.4 109.2 344 97.6L344 87.9C344 74.6 333.3 63.9 320 63.9zM488.4 432L151.5 432L164.4 409.9C187.7 370 200 324.6 200 278.5L200 264C200 197.7 253.7 144 320 144C386.3 144 440 197.7 440 264L440 278.5C440 324.7 452.3 370 475.5 409.9L488.4 432zM252.1 528C262 556 288.7 576 320 576C351.3 576 378 556 387.9 528L252.1 528z"/>
            </svg>
            @if(!empty($unreadCount) && $unreadCount > 0)
                <span class="absolute top-0 right-0 block h-2 w-2 rounded-full bg-red-500"></span>
            @endif
        </div>
    </x-slot>

    <x-slot name="content">
        <div class="notificationBox px-4 py-2 text-gray-700 dark:text-gray-300">
            <!-- <p class="text-sm font-semibold">Wallet: 💰 ₹{{ auth()->user()->wallet_balance }}</p> -->
        </div>
        <div class="border-t border-gray-200 dark:border-gray-700"></div>

        @forelse($userNotifications as $notification)
            <x-dropdown-link href="#">
                {{ $notification->message }}
            </x-dropdown-link>
        @empty
            <x-dropdown-link href="#">
                ✅ No new notifications
            </x-dropdown-link>
        @endforelse
    </x-slot>
</x-dropdown>


            
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="inline-flex items-center px-3 py-2 border rounded-md text-sm font-medium text-gray-500 dark:text-gray-400 dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none transition">
                            <img src="https://ui-avatars.com/api/?name={{ urlencode(Auth::user()->name) }}&background=374151&color=fff"
                                 alt="Profile"
                                 class="h-6 w-6 rounded-full mr-2">
                            <div>{{ Auth::user()->name }}</div>
                            <div class="ms-1">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 
                                    1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 
                                    010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('user.profile.edit')">
                            {{ __('Profile') }}
                        </x-dropdown-link>
                        <!-- Authentication -->
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <x-dropdown-link :href="route('logout')"
                                onclick="event.preventDefault(); this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>
 
            <div class="-me-2 flex items-center sm:hidden">
                <div class="flex items-center space-x-2 text-gray-700 dark:text-gray-300">
      <p class="text-sm font-semibold">Wallet: 💰 ₹{{ auth()->user()->wallet_balance }}</p>
      
    <!-- <svg class="h-6 w-6 text-gray-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
        <path fill="#9ca3af" d="M128 96C92.7 96 64 124.7 64 160L64 448C64 483.3 92.7 512 128 512L512 512C547.3 512 576 483.3 576 448L576 256C576 220.7 547.3 192 512 192L136 192C122.7 192 112 181.3 112 168C112 154.7 122.7 144 136 144L520 144C533.3 144 544 133.3 544 120C544 106.7 533.3 96 520 96L128 96zM480 320C497.7 320 512 334.3 512 352C512 369.7 497.7 384 480 384C462.3 384 448 369.7 448 352C448 334.3 462.3 320 480 320z"/>
    </svg>
    
    <span style="margin-right:10px;margin-left: 5px;" class="font-semibold">{{Auth::user()->wallet_balance}}</span> -->
</div>


                            <x-dropdown align="right" width="64">
    <x-slot name="trigger">
        <div style="cursor:pointer" class="relative inline-flex items-center p-2 text-gray-500 dark:text-gray-400 dark:hover:text-gray-300 focus:outline-none transition">
            <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                <path fill="#9ca3af" d="M320 64C306.7 64 296 74.7 296 88L296 97.7C214.6 109.3 152 179.4 152 264L152 278.5C152 316.2 142 353.2 123 385.8L101.1 423.2C97.8 429 96 435.5 96 442.2C96 463.1 112.9 480 133.8 480L506.2 480C527.1 480 544 463.1 544 442.2C544 435.5 542.2 428.9 538.9 423.2L517 385.7C498 353.1 488 316.1 488 278.4L488 263.9C488 179.3 425.4 109.2 344 97.6L344 87.9C344 74.6 333.3 63.9 320 63.9zM488.4 432L151.5 432L164.4 409.9C187.7 370 200 324.6 200 278.5L200 264C200 197.7 253.7 144 320 144C386.3 144 440 197.7 440 264L440 278.5C440 324.7 452.3 370 475.5 409.9L488.4 432zM252.1 528C262 556 288.7 576 320 576C351.3 576 378 556 387.9 528L252.1 528z"/>
            </svg>
            @if(!empty($unreadCount) && $unreadCount > 0)
                <span class="absolute top-0 right-0 block h-2 w-2 rounded-full bg-red-500"></span>
            @endif
        </div>
    </x-slot>

    <x-slot name="content">
        <div class="notificationBox px-4 py-2 text-gray-700 dark:text-gray-300">
            <!-- <p class="text-sm font-semibold">Wallet: 💰 ₹{{ auth()->user()->wallet_balance }}</p> -->
        </div>
        <div class="border-t border-gray-200 dark:border-gray-700"></div>

        @forelse($userNotifications as $notification)
            <x-dropdown-link href="#">
                🔔 {{ $notification->message }}
            </x-dropdown-link>
        @empty
            <x-dropdown-link href="#">
                ✅ No new notifications
            </x-dropdown-link>
        @endforelse
    </x-slot>
</x-dropdown>

                <button @click="open = ! open"
                        class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none transition">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex"
                              stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden"
                              stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

 
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <!--<x-responsive-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin.dashboard')">-->
            <!--    {{ __('Dashboard') }}-->
            <!--</x-responsive-nav-link>-->

            <x-responsive-nav-link :href="url('user/keys')" :active="request()->routeIs('user.keys.*')">
                {{ __('Generate Key') }}
            </x-responsive-nav-link>

            <x-responsive-nav-link :href="route('user.order-history')" :active="request()->routeIs('user.order-history')">
                {{ __('Order History') }}
            </x-responsive-nav-link>
 
        </div>

 
        <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-600">
            <div class="px-4">
                <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('user.profile.edit')">
                    {{ __('Profile') }}
                </x-responsive-nav-link>  
     
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <x-responsive-nav-link :href="route('logout')"
                            onclick="event.preventDefault(); this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>
