@extends('user.layout')
@section('content')

@php
    $assigned = explode(',', Auth::user()->asign_id);
@endphp


<div class="py-12 max-w-7xl mx-auto">
    <div class="flex flex-col lg:flex-row gap-4">

        <div class="w-full lg:w-[30%]">
            
                @if(session('success'))
    <div class="mb-4 p-4 bg-green-100  text-green-800 rounded">
        {{ session('success') }}
    </div>
@endif

@if(session('keys'))
        <div class="mb-4 p-4 bg-gray-100 dark:bg-gray-700 rounded">
            <p class="font-bold text-gray-800 dark:text-gray-200 mb-2">Your Keys:</p>
            @foreach(session('keys') as $key)
                <div class="flex items-center mb-2">
                    <input type="text" value="{{ $key }}" readonly
                           class="w-full border rounded px-2 py-1 dark:bg-gray-800 dark:text-gray-200">
                    <button onclick="copyToClipboard('{{ $key }}')" 
                            class="ml-2 px-3 py-1 bg-indigo-600 text-white text-sm rounded hover:bg-indigo-700">
                        Copy
                    </button>
                </div>
            @endforeach
        </div>
    @endif
 



@if(session('error'))
    <div class="mb-4 p-4 bg-red-100  text-red-800 rounded">
        {{ session('error') }}
    </div>
@endif

@if($errors->any())
    <div class="mb-4 p-4 bg-yellow-100  text-yellow-800 rounded">
        <ul class="list-disc pl-6">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif


            <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg p-6">
                <h2 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-4">Generate Key</h2>

                <!-- Product Select -->
                <form method="GET" action="{{ route('user.keys.index') }}" class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Select Product</label>
                    <select name="product_id" onchange="this.form.submit()"
                        class="w-full border-gray-300 dark:border-gray-700 rounded-md">
                        <option value="">-- Select --</option>
                        @if(Auth::user()->asign_id)
                      @foreach($products as $product)
                      @if(in_array($product->id, $assigned))
    <option value="{{ $product->id }}">
        {{ $product->name }}
    </option>
    @endif
@endforeach
                        @else 
                        @foreach($products as $product)
                    
                            <option value="{{ $product->id }}" {{ request('product_id') == $product->id ? 'selected' : '' }}>
                                {{ $product->name }}
                            </option>
                        
                        @endforeach
                        
                           @endif
                    </select>
                </form>

                @if($keys->count())
                <form action="{{ route('user.keys.store') }}" method="POST" id="generateKeyForm">
                    @csrf
                    <input type="hidden" name="product_id" value="{{ request('product_id') }}">
 
                    <!-- Duration + Price Select -->
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Select Duration</label>
                    <select name="duration" id="keySelect"
                        class="w-full border-gray-300 dark:border-gray-700 rounded-md mb-4">
                        @foreach($keys as $key)
                            <option value="{{ $key->duration }}" data-price="{{ $key->price }}">
                                {{ $key->duration }} Days - ${{ $key->price }}
                            </option>
                        @endforeach
                    </select>

                    <!-- Quantity -->
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Quantity</label>
                    <select name="quantity" id="quantitySelect" 
                        class="w-full border-gray-300 dark:border-gray-700 rounded-md mb-4">
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                    </select>

                    <!-- Total Price -->
                    <div class="mb-4 text-gray-800 dark:text-gray-200">
                        <strong>Total Price: $<span id="totalPrice">0</span></strong>
                    </div>

                    <button type="submit" 
                        class="px-4 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-700">
                        Generate Key
                    </button>
                </form>
                @endif
            </div>
        </div>
    </div>
</div>

 <script>
function calculateTotal() {
    let price = parseFloat(document.querySelector("#keySelect option:checked")?.dataset.price || 0);
    let qty = parseInt(document.getElementById("quantitySelect")?.value || 1);
    document.getElementById("totalPrice").innerText = price * qty;
}

document.getElementById("keySelect")?.addEventListener("change", calculateTotal);
document.getElementById("quantitySelect")?.addEventListener("change", calculateTotal);
window.onload = calculateTotal;
</script>
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert("Key copied to clipboard!");
    });
}
</script>
@endsection
