@extends('user.layout')

@section('content')
<div class="py-12 max-w-7xl mx-auto space-y-6">
 
    <!-- New Row with 2 Columns -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg">
        <!-- Column 1 -->
        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-6">
            <h3 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-2">Wallet Balance</h3>
            <p class="text-2xl font-bold text-green-600">${{ Auth::user()->wallet_balance ?? 0 }}</p>
            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Available balance in your wallet</p>
        </div>

        <!-- Column 2 -->
        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-6">
            <h3 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-2">Recent Order</h3>
            <p class="text-sm text-gray-500 dark:text-gray-400">Last order placed on:</p>
            <p class="text-md font-semibold text-indigo-600 mt-1">
                {{ optional(Auth::user()->orders()->latest()->first())->created_at?->format('d M Y H:i') ?? 'No orders yet' }}
            </p>
        </div>
    </div>

</div>
@endsection
