<nav x-data="{ open: false }" class=" dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700">
    <!-- Primary Navigation Menu -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('admin.dashboard') }}">
                        <x-application-logo class="block h-9 w-auto fill-current text-gray-800 dark:text-gray-200" />
                    </a>
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin/dashboard')">
                        {{ __('Dashboard') }}
                    </x-nav-link>
                </div>

                 <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('products.index')" :active="request()->routeIs('admin/product')">
                        {{ __('Product add') }}
                    </x-nav-link>
                </div>

           
                <!--<div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">-->
                <!--    <x-nav-link :href="route('product-prices.create')" :active="request()->routeIs('admin/generate-key')">-->
                <!--        {{ __('Product Price') }}-->
                <!--    </x-nav-link>-->
                <!--</div>-->

                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('admin.generate-key')" :active="request()->routeIs('admin/generate-key')">
                        {{ __('Add Key') }}
                    </x-nav-link>
                </div>
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('admin.order-history')" :active="request()->routeIs('order-history')">
                        {{ __('Order History') }}
                    </x-nav-link>
                </div>

                  <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="url('admin/users/create')" :active="request()->routeIs('users/create')">
                        {{ __('Create Users') }}
                    </x-nav-link>
                </div>
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="url('admin/users')" :active="request()->routeIs('users')">
                        {{ __('Users') }}
                    </x-nav-link>
                </div>

 
          

            </div>
 
<div class="hidden sm:flex sm:items-center sm:ms-6 space-x-4">

 
    <x-dropdown align="right" width="64">
        <x-slot name="trigger">
            <div class="relative inline-flex items-center p-2 text-gray-500 dark:text-gray-400 dark:hover:text-gray-300 focus:outline-none transition">
              
                 <svg class="h-6 w-6"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                 <path fill="#9ca3af" d="M320 64C306.7 64 296 74.7 296 88L296 97.7C214.6 109.3 152 179.4 152 264L152 278.5C152 316.2 142 353.2 123 385.8L101.1 423.2C97.8 429 96 435.5 96 442.2C96 463.1 112.9 480 133.8 480L506.2 480C527.1 480 544 463.1 544 442.2C544 435.5 542.2 428.9 538.9 423.2L517 385.7C498 353.1 488 316.1 488 278.4L488 263.9C488 179.3 425.4 109.2 344 97.6L344 87.9C344 74.6 333.3 63.9 320 63.9zM488.4 432L151.5 432L164.4 409.9C187.7 370 200 324.6 200 278.5L200 264C200 197.7 253.7 144 320 144C386.3 144 440 197.7 440 264L440 278.5C440 324.7 452.3 370 475.5 409.9L488.4 432zM252.1 528C262 556 288.7 576 320 576C351.3 576 378 556 387.9 528L252.1 528z"/>
                </svg>

  
                <!-- <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                          d="M15 17h5l-1.405-1.405C18.21 14.79 18 13.918 18 13V10a6 6 0 00-9.33-5.024M9 21h6"/>
                </svg> -->

                
                <span class="absolute top-0 right-0 block h-2 w-2 rounded-full bg-red-500"></span>
            </div>
        </x-slot>

        <x-slot name="content">
            <div class="px-4 py-2 text-gray-700 dark:text-gray-300">
                <p class="text-sm font-semibold">Notifications</p>
            </div>
            <div class="border-t border-gray-200 dark:border-gray-700"></div>

            <!-- Example Notifications -->
            <x-dropdown-link href="#">
                🔔 New comment on your post
            </x-dropdown-link>
            <x-dropdown-link href="#">
                📩 You have 3 new messages
            </x-dropdown-link>
            <x-dropdown-link href="#">
                ⚠️ Server downtime alert
            </x-dropdown-link>
        </x-slot>
    </x-dropdown>


    <!-- 👤 Profile Dropdown -->
    <x-dropdown align="right" width="48">
        <x-slot name="trigger">
            <button class="inline-flex items-center px-3 py-2 border rounded-md text-sm font-medium text-gray-500 dark:text-gray-400 dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none transition">
                
                <!-- Profile Avatar -->
                <img src="https://ui-avatars.com/api/?name={{ urlencode(Auth::user()->name) }}&background=374151&color=fff"
                     alt="Profile"
                     class="h-6 w-6 rounded-full mr-2">
                
                <div>{{ Auth::user()->name }}</div>

                <div class="ms-1">
                    <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 
                        1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 
                        010-1.414z" clip-rule="evenodd" />
                    </svg>
                </div>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-dropdown-link :href="route('profile.edit')">
                {{ __('Profile') }}
            </x-dropdown-link>

            <!-- Authentication -->
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <x-dropdown-link :href="route('logout')"
                    onclick="event.preventDefault(); this.closest('form').submit();">
                    {{ __('Log Out') }}
                </x-dropdown-link>
            </form>
        </x-slot>
    </x-dropdown>

</div>

 
            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500 dark:focus:text-gray-400 transition duration-150 ease-in-out">
          
                <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

<!-- Responsive Navigation Menu -->
<div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
    <div class="pt-2 pb-3 space-y-1">
        <x-responsive-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin/dashboard')">
            {{ __('Dashboard') }}
        </x-responsive-nav-link>

        <x-responsive-nav-link :href="route('products.index')" :active="request()->routeIs('admin/product')">
            {{ __('Product Add') }}
        </x-responsive-nav-link>

        <!--<x-responsive-nav-link :href="route('product-prices.create')" :active="request()->routeIs('admin/product-prices')">-->
        <!--    {{ __('Product Price') }}-->
        <!--</x-responsive-nav-link>-->

        <x-responsive-nav-link :href="route('admin.generate-key')" :active="request()->routeIs('admin/generate-key')">
            {{ __('Add Key') }}
        </x-responsive-nav-link>

        <x-responsive-nav-link :href="route('admin.order-history')" :active="request()->routeIs('order-history')">
            {{ __('Order History') }}
        </x-responsive-nav-link>

        
        <x-responsive-nav-link :href="url('admin/users/create')" :active="request()->routeIs('users/create')">
            {{ __('User Create') }}
        </x-responsive-nav-link>

        
        <x-responsive-nav-link :href="url('admin/users')" :active="request()->routeIs('users')">
             {{ __('Users') }}
        </x-responsive-nav-link>


    </div>
  
        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-600">
            <div class="px-4">
                <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">
                    {{ __('Profile') }}
                </x-responsive-nav-link>

                <!-- Authentication -->
                <form method="POST" action="{{ route('logout') }}">
                    @csrf

                    <x-responsive-nav-link :href="route('logout')"
                            onclick="event.preventDefault();
                                        this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>
