<x-app-layout>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <div class="py-12 max-w-7xl mx-auto">
<div class="p-6  shadow-sm sm:rounded-lg mx-auto bg-white dark:bg-gray-800">
    <h2 class="text-lg font-bold mb-4 text-gray-800 dark:text-gray-200">Create User</h2>

    @if(session('success'))
        <div class="mb-4 p-3 bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200 rounded">
            {{ session('success') }}
        </div>
    @endif
{{-- Error Message (global error) --}}
@if(session('error'))
    <div class="mb-4 p-3 rounded text-red-800">
        {{ session('error') }}
    </div>
@endif

{{-- Validation Errors (multiple) --}}
@if($errors->any())
    <div class="mb-4 p-3 rounded text-red-800">
        <ul class="list-disc ps-5 space-y-1">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
    <form action="{{ route('users.store') }}" method="POST" class="space-y-4">
        @csrf

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Name</label>
            <input type="text" name="name" 
                   class="w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 rounded p-2" 
                   required>
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Email</label>
            <input type="email" name="email" 
                   class="w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 rounded p-2" 
                   required>
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Password</label>
            <input type="password" name="password" 
                   class="w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 rounded p-2" 
                   required>
        </div>

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Confirm Password</label>
            <input type="password" name="password_confirmation" 
                   class="w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 rounded p-2" 
                   required>
        </div>
@php

$product = DB::table('products')->select('id','name')->get();


@endphp <div>
 <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Products</label>
<select id="keySelect" name="asign_id[]" multiple
        class="w-full min-h-[120px] border border-gray-300 dark:border-gray-600 
               rounded-lg p-2 bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200
               focus:border-indigo-500 focus:ring focus:ring-indigo-200">
    <option value="">-- Select Products --</option>
    @foreach ($product as $value)
        <option value="{{ $value->id }}">{{ $value->name }}</option>
    @endforeach
</select>
 <div>
                

        <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Initial Wallet Balance</label>
            <input type="number" step="0.01" name="wallet_balance" 
                   class="w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 rounded p-2">
        </div>

        <button type="submit" 
                class="bg-indigo-600 hover:bg-indigo-700 text-white px-4 py-2 rounded transition">
            Create
        </button>
    </form>
</div></div>
<script>
$(document).ready(function() {
    $('#keySelect').select2();
});

</script>
</x-app-layout>
