<x-app-layout>
<div class="flex flex-col lg:flex-row gap-4 py-12 max-w-7xl mx-auto ">
    <div class="md:p-12">
        <h2 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-6">
            Order History
        </h2>
 
                
                     
                <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg text-gray-900 dark:text-gray-100 p-2">

 <table id="keysTable" class="table-auto w-full border-collapse border border-gray-300">
  <thead>
    <tr class="bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-200">
      <th class="border p-2">ID</th>
      <th class="border p-2">User</th>
      <th class="border p-2">Product</th>
      <th class="border p-2">Key</th>
      <th class="border p-2">Duration</th>
      <th class="border p-2">Price</th>
      <th class="border p-2">Date</th>
         <th class="border p-2">Status</th>
    </tr>
  </thead>
  <tbody>
    @forelse($orders as $order)
      <tr>
        <td class="border p-2">{{ $order->id }}</td>
          <td class="border p-2">{{ $order->user_name  }}</td>
        <td class="border p-2">{{ $order->product->name ?? 'N/A' }}</td>
        <td class="border p-2 font-mono">
             {{ $order->key->decrypted_key ?? 'N/A' }}
                            @if($order->key?->decrypted_key)
                                <button onclick="copyToClipboard('{{ $order->key->decrypted_key }}')" class="ml-2 border-none">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" viewBox="0 0 640 640">
                                        <path fill="#4f46e5" d="M288 64C252.7 64 224 92.7 224 128L224 384C224 419.3 252.7 448 288 448L480 448C515.3 448 544 419.3 544 384L544 183.4C544 166 536.9 149.3 524.3 137.2L466.6 81.8C454.7 70.4 438.8 64 422.3 64L288 64zM160 192C124.7 192 96 220.7 96 256L96 512C96 547.3 124.7 576 160 576L352 576C387.3 576 416 547.3 416 512L416 496L352 496L352 512L160 512L160 256L176 256L176 192L160 192z"/>
                                    </svg>
                                </button>
                            @endif
        </td>
        <td class="border p-2">
          {{ $order->duration ?? '-' }} Days
        </td>
        <td class="border p-2">${{ $order->total_price }}</td>
        <td class="border p-2">{{ $order->created_at->format('d M Y H:i') }}</td>
        <td class="px-4 py-2">
                            <span class="px-2 py-1 text-xs rounded text-white 
                                {{ $order->status == 'completed' ? 'bg-green-500' : 'bg-yellow-500' }}">
                                {{ ucfirst($order->status) }}
                            </span>
                        </td>
      </tr>
    @empty
       No keys found 
    
    @endforelse
  </tbody>
</table>


           
             </div>
 

    </div>
</div>
</x-app-layout>
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert("Key copied to clipboard!");
    });
}
</script>