<x-app-layout>



<div class="flex flex-col lg:flex-row gap-4 py-12 max-w-7xl mx-auto">
  <div class="w-full lg:w-[30%]">
<div class="max-w-3xl mx-auto">
    <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg p-6">
        <h2 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-4">Add New Key</h2>

   {{-- Success Message --}}
@if(session('success'))
    <div class="mb-4 p-3 rounded bg-green-100 text-green-800">
        {{ session('success') }}
    </div>
@endif

{{-- Error Message (global error) --}}
@if(session('error'))
    <div class="mb-4 p-3 rounded text-red-800">
        {{ session('error') }}
    </div>
@endif

{{-- Validation Errors (multiple) --}}
@if($errors->any())
    <div class="mb-4 p-3 rounded text-red-800">
        <ul class="list-disc ps-5 space-y-1">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('keys.store') }}" method="POST" class="space-y-4">
    @csrf

    <!-- Product -->
    <div>
        <label class="block text-sm text-gray-700 dark:text-gray-300 mb-1">Select Product</label>
        <select name="product_id" class="w-full border-gray-300 dark:border-gray-700 rounded-md" required>
            <option value="">-- Select Product --</option>
            @foreach($products as $product)
                <option value="{{ $product->id }}">{{ $product->name }}</option>
            @endforeach
        </select>
    </div>

    <!-- Keys (Bulk) -->
    <div>
        <label class="block text-sm text-gray-700 dark:text-gray-300 mb-1">Keys (one per line)</label>
        <textarea name="encrypted_keys" rows="6"
               class="w-full border-gray-300 dark:border-gray-700 rounded-md dark:bg-gray-700 dark:text-gray-200"
               placeholder="Enter one key per line" required></textarea>
    </div>

    <!-- Duration -->
    <div>
        <label class="block text-sm text-gray-700 dark:text-gray-300 mb-1">Duration (Days)</label>
        <input type="number" name="duration" 
               class="w-full border-gray-300 dark:border-gray-700 rounded-md dark:bg-gray-700 dark:text-gray-200" 
               placeholder="e.g. 30" required>
    </div>

    <!-- Price -->
    <div>
        <label class="block text-sm text-gray-700 dark:text-gray-300 mb-1">Price ($)</label>
        <input type="number" step="0.01" name="price" 
               class="w-full border-gray-300 dark:border-gray-700 rounded-md dark:bg-gray-700 dark:text-gray-200" 
               placeholder="e.g. 499.00" required>
    </div>

    <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded-md hover:bg-gray-700">
        Save Keys in Bulk
    </button>
</form>


    </div>
</div>
</div>
  <div class="w-full lg:w-[60%]">
     
  <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg">
                
                    
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
         Total Keys
        </h2>
        <br>
 <table id="keysTable" class="table-auto w-full border-collapse border border-gray-300">
  <thead>
    <tr class="bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-200">
      <th class="border p-2">ID</th>
      <th class="border p-2">Product</th>
      <th class="border p-2">Key</th>
      <th class="border p-2">Status</th>
      <th class="border p-2">Added By</th>
      <th class="border p-2">Date</th>
    </tr>
  </thead>
  <tbody>
    @forelse($keys as $key)
      <tr>
        <td class="border p-2">{{ $key->id }}</td>
        <td class="border p-2">{{ $key->product->name ?? 'N/A' }}</td>
        <td class="border p-2 font-mono">{{ $key->decrypted_key }} <button  onclick="copyToClipboard('{{ $key->decrypted_key }}')" 
                            class="ml-2  pt-2 border-none">
                   <svg xmlns="http://www.w3.org/2000/svg" width="20" viewBox="0 0 640 640"><!--!Font Awesome Free v7.0.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path fill="#4f46e5" d="M288 64C252.7 64 224 92.7 224 128L224 384C224 419.3 252.7 448 288 448L480 448C515.3 448 544 419.3 544 384L544 183.4C544 166 536.9 149.3 524.3 137.2L466.6 81.8C454.7 70.4 438.8 64 422.3 64L288 64zM160 192C124.7 192 96 220.7 96 256L96 512C96 547.3 124.7 576 160 576L352 576C387.3 576 416 547.3 416 512L416 496L352 496L352 512L160 512L160 256L176 256L176 192L160 192z"/></svg>
                    </button></td>
        <td class="border p-2">
          <span class="px-2 py-1 rounded text-white text-xs 
            {{ $key->is_used ? 'bg-red-500' : 'bg-green-500' }}">
            {{ $key->is_used ? 'Used' : 'Available' }}
          </span>
        </td>
        <td class="border p-2">{{ $key->user->name ?? 'Admin' }}</td>
        <td class="border p-2">{{ $key->created_at->format('d M Y H:i') }}</td>
      </tr>
    @empty
      <tr>
        <td colspan="6" class="text-center p-4 text-gray-500">No keys found</td>
      </tr>
    @endforelse
  </tbody>
</table>


                </div>  
             </div>
  </div>
</div>

    </div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert("Key copied to clipboard!");
    });
}
</script>
</x-app-layout>
