<x-app-layout>
    <div class="py-12 max-w-7xl mx-auto space-y-6">

 <div class="dashgrid p-6">
    <!-- Box 1 -->
    <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-6 text-center dashbox">
        <h3 class="text-sm font-medium text-gray-600 dark:text-gray-300">Total Users</h3>
        <p class="text-2xl font-bold text-green-600">{{ $totalUsers }}</p>
    </div>

    <!-- Box 2 -->
    <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-6 text-center dashbox">
        <h3 class="text-sm font-medium text-gray-600 dark:text-gray-300">Total Orders</h3>
        <p class="text-2xl font-bold text-green-600">{{ $totalOrders }}</p>
    </div>

    <!-- Box 3 -->
    <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-6 text-center dashbox">
        <h3 class="text-sm font-medium text-gray-600 dark:text-gray-300">Total Revenue</h3>
        <p class="text-2xl font-bold text-green-600">${{ number_format($totalRevenue, 2) }}</p>
    </div>

    <!-- Box 4 -->
    <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-6 text-center dashbox">
        <h3 class="text-sm font-medium text-gray-600 dark:text-gray-300">Available Keys</h3>
        <p class="text-2xl font-bold text-green-600">{{ $availableKeys }}</p>
    </div>
</div>
        
        <div class=" ">
            <div class="p-6 text-gray-900 dark:text-gray-100">
                <h2 class="text-lg font-bold text-gray-700 dark:text-gray-300 mb-4">Recent Orders</h2>

             <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    @forelse($recentOrders as $order)
        <div class="bg-white dark:bg-gray-800   rounded-xl p-4">
            <div class="flex justify-between items-center mb-2">
                <h3 class="text-md font-bold text-gray-700 dark:text-gray-200">
                    #{{ $order->id }}
                </h3>
                <span class="px-2 py-1 rounded text-white text-xs 
                    {{ $order->status == 'completed' ? 'bg-green-500' : 'bg-yellow-500' }}">
                    {{ ucfirst($order->status) }}
                </span>
            </div>

            <p class="text-sm text-gray-600 dark:text-gray-400">
                <span class="font-semibold">User:</span> {{ $order->user->name }}
            </p>
            <p class="text-sm text-gray-600 dark:text-gray-400">
                <span class="font-semibold">Product:</span> {{ $order->product?$order->product->name:'' }}
            </p>
            <p class="text-sm text-gray-600 dark:text-gray-400">
                <span class="font-semibold">Price:</span> ₹{{ $order->total_price }}
            </p>
            <p class="text-sm text-gray-600 dark:text-gray-400">
                <span class="font-semibold">Date:</span> {{ $order->created_at->format('d M Y H:i') }}
            </p>
        </div>
    @empty
        <div class="col-span-full text-center p-4 text-gray-500 bg-white dark:bg-gray-800 rounded-lg">
            No orders yet
        </div>
    @endforelse
</div>

            </div>
        </div>

    </div>
</x-app-layout>
