<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Model;
  

class Order extends Model
{
    protected $fillable = ['product_id', 'user_id', 'key_id', 'total_price', 'status','duration'];

    public function key()
    {
        return $this->belongsTo(Key::class, 'key_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
      public function getDecryptedKeyAttribute() {
        return Crypt::decryptString($this->encrypted_key);
    }


    public function setEncryptedKeyAttribute($value) {
        $this->attributes['encrypted_key'] = Crypt::encryptString($value);
    }
 
    
}

