<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;
class Key extends Model
{
    protected $fillable = ['product_id','user_id','encrypted_key','duration','price','is_used'];

    public function product() {
        return $this->belongsTo(Product::class);
    }

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function order() {
        return $this->hasOne(Order::class);
    }

   
    public function getDecryptedKeyAttribute() {
        return Crypt::decryptString($this->encrypted_key);
    }

  
    public function setEncryptedKeyAttribute($value) {
        $this->attributes['encrypted_key'] = Crypt::encryptString($value);
    
    }
    
}

