<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
class UserController extends Controller
{
       public function index(Request $request)
    {
          $query = User::query();

 
    if ($request->filled('search')) {
        $search = $request->search;
        $query->where(function ($q) use ($search) {
            $q->where('name', 'like', "%{$search}%")
              ->orWhere('email', 'like', "%{$search}%");
        });
    }

    $users = $query->latest()->paginate(10)->appends($request->only('search'));
        return view('admin.users.index', compact('users'));
    }

    public function create()
    {
        return view('admin.users.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|email|unique:users,email',
            'password' => 'required|min:6|confirmed',
            'wallet_balance' => 'nullable|numeric|min:0',
        ]);

        $user = User::create([
            'name'     => $request->name,
            'email'    => $request->email,
               'role'    => 'user',
            'password' => bcrypt($request->password),
            'wallet_balance' => $request->wallet_balance ?? 0,
          'asign_id' => $request->asign_id ? implode(',', $request->asign_id) : null,
        ]);

        return redirect()->route('users.index')->with('success', 'User created successfully!');
    }

public function addWallet(Request $request, User $user)
{
    $request->validate([
        'amount' => 'required|numeric|min:1',
    ]);

  
    $user->wallet_balance += $request->amount;
    $user->save();

 
    \App\Models\WalletTransaction::create([
        'user_id'       => $user->id,
        'type'          => 'credit',
        'amount'        => $request->amount,
        'balance_after' => $user->wallet_balance,
        'description'   => 'Wallet top-up by Admin',
        'status'        => 'success',
    ]);

 
    \App\Models\Notification::create([
        'user_id' => $user->id,
        'message' => "ðŸ’° Admin added â‚¹{$request->amount} to your wallet. New Balance: â‚¹{$user->wallet_balance}",
    ]);

    return back()->with('success', 'Wallet updated and notification sent successfully!');
}
   public function destroy($id)
    {
       
        $user = User::findOrFail($id);
        $user->delete();

        return redirect()->back()
                         ->with('success', 'User deleted successfully.');
    }
    
    public function toggleBlock($id)
{
    $user = User::findOrFail($id);

    $user->is_blocked = !$user->is_blocked; // true <-> false toggle
    $user->save();

    return redirect()->back()
                     ->with('success', $user->is_blocked ? 'User blocked.' : 'User unblocked.');
}

}
