<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use Auth;
class OrderController extends Controller
{
  public function index(Request $request)
    {
           $query = Order::with(['product', 'key'])->where('user_id',Auth::user()->id)->latest();

 if ($request->filled('search')) {
    $query->whereHas('key', function ($q) use ($request) {
        $q->where('key_preview', 'like', '%' . $request->search . '%');
    });
}

    $orders = $query->paginate(10)->appends($request->only('search'));
    
    
        return view('user.orderhistory', compact('orders'));
    }
}