<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\WalletTransaction;


class GenerateKeyController extends Controller
{
    /**
     * Display a listing of the resource.
     */
public function index()
{
    $products = \App\Models\Product::all();

  
    $keys = collect();

    if (request()->has('product_id')) {
        $keys = \App\Models\Key::where('product_id', request('product_id'))
            ->where('is_used', 0)
            ->select('duration', 'price') 
            ->groupBy('duration', 'price') 
            ->get();
    }

    return view('user.keys.index', compact('products', 'keys'));
}

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
     
  public function store(Request $request)
{
    $request->validate([
        'product_id' => 'required|exists:products,id',
        'quantity'   => 'required|integer|min:1',
        'duration'   => 'required|integer', 
    ]);

    $user = auth()->user();

 
    $selectedKey = \App\Models\Key::where('product_id', $request->product_id)
                    ->where('duration', $request->duration)
                    ->where('is_used', 0)
                    ->first();

    if (!$selectedKey) {
        return back()->with('error', 'No available keys for this product/duration.');
    }

    $totalPrice = $selectedKey->price * $request->quantity;

    if ($user->wallet_balance < $totalPrice) {
        return back()->with('error', 'Not enough wallet balance.');
    }

    $generatedKeys = [];

    for ($i = 0; $i < $request->quantity; $i++) {
        // random available key pick karo
        $key = \App\Models\Key::where('product_id', $request->product_id)
                ->where('duration', $request->duration)
                ->where('is_used', 0)
                ->inRandomOrder()
                ->first();

        if (!$key) {
            return back()->with('error', 'Not enough keys available for this quantity.');
        }

        $key->update([
            'is_used' => 1,
            'user_id' => $user->id
        ]);

        // create order
        $order = \App\Models\Order::create([
            'product_id'  => $request->product_id,
            'user_id'     => $user->id,
            'key_id'      => $key->id,
            'total_price' => $selectedKey->price,
            'duration'    => $request->duration,
            'status'      => 'completed',
        ]);

        \App\Models\Notification::create([
            'user_id' => $user->id,
            'message' => "Your order #{$order->id} is completed. Key assigned.",
        ]);

        $generatedKeys[] = $key->decrypted_key;
    }

    $user->wallet_balance -= $totalPrice;
    $user->save();

    return redirect()->route('user.keys.index')
        ->with('success', 'Order placed successfully!')
        ->with('keys', $generatedKeys);
}




//   public function store(Request $request)
// {
//     $request->validate([
//         'product_id'  => 'required|exists:products,id',
//         'duration_id' => 'required|exists:product_prices,id',
//         'quantity'    => 'required|integer|min:1',
//     ]);

//     $user = auth()->user();

//     $price = \App\Models\ProductPrice::findOrFail($request->duration_id);
//     $totalPrice = $price->price * $request->quantity;

   
//     if ($user->wallet_balance < $totalPrice) {
//         return back()->with('error', 'Not enough wallet balance.');
//     }

  
//     for ($i = 0; $i < $request->quantity; $i++) {
      
//         $key = \App\Models\Key::where('product_id', $request->product_id)
//                 ->where('is_used', 0)
//                 ->first();

//         if (!$key) {
//             return back()->with('error', 'No available keys for this product.');
//         }

    
//         $key->update(['is_used' => 1]);

     
//         $order = \App\Models\Order::create([
//             'product_id'  => $request->product_id,
//             'user_id'     => $user->id,
//             'key_id'      => $key->id,
//             'total_price' => $price->price,
//             'duration'    => $price->duration,
//             'status'      => 'completed',
//         ]);
        
        

       
//         // \App\Models\Notification::create([
//         //     'user_id' => $user->id,
//         //     'message' => "Your order #{$order->id} is completed. Key: {$key->generated_key}",
//         // ]);

       
//         WalletTransaction::create([
//             'user_id'       => $user->id,
//             'type'          => 'debit',
//             'amount'        => $price->price,
//             'balance_after' => $user->wallet_balance - $price->price,  
//             'description'   => "Order #{$order->id} - Product {$order->product->name}",
//             'status'        => 'success',
//         ]);

      
//         $user->wallet_balance -= $price->price;
//         $user->save();
//     }

//     return redirect()->route('user.keys.index')->with('success', 'Order placed successfully!');
// }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
