<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\ProductPrice;

class ProductPriceController extends Controller
{
    public function create()
    {
        $products = Product::all();
         $prices = \App\Models\ProductPrice::with('product')->get();
        return view('admin.product_prices.create', compact('products','prices'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'product_id' => 'required|exists:products,id',
            'duration'   => 'required|integer|min:1',
            'price'      => 'required|numeric|min:0',
        ]);

        ProductPrice::create($request->only('product_id', 'duration', 'price'));

        return redirect()->back()->with('success', 'Price added successfully!');
    }
}
