<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;

class ProductController extends Controller
{
    // Show all products
    public function index()
    {
       $products = Product::withCount([
        'keys as used_keys_count' => function ($q) {
            $q->where('is_used', 1);
        },
        'keys as unused_keys_count' => function ($q) {
            $q->where('is_used', 0);
        },
    ])->get();
   return view('admin.products.index', compact('products'));
    }

    // Show form to create product
    public function create()
    {
        
        return view('products.create');
    }

    // Store new product
    public function store(Request $request)
    {
       
        $request->validate([
            'name'  => 'required|string|max:255',
        ]);

        Product::create($request->all());

        return redirect()->route('products.index')->with('success', 'Product created successfully.');
    }

    // Show single product
    public function show(Product $product)
    {
        return view('products.show', compact('product'));
    }

    // Show edit form
    public function edit(Product $product)
    {
        return view('products.edit', compact('product'));
    }

    // Update product
    public function update(Request $request, Product $product)
    {
        $request->validate([
            'name'  => 'required|string|max:255',
        ]);

        $product->update($request->all());

        return redirect()->route('products.index')->with('success', 'Product updated successfully.');
    }

    // Delete product
    public function destroy(Product $product)
    {
        $product->delete();

        return redirect()->route('products.index')->with('success', 'Product deleted successfully.');
    }
}
