<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Key;

class KeyImportController extends Controller
{
    public function import(Request $request)
    {
        $request->validate([
            'product_id' => 'required|exists:products,id',
            'keys_file'  => 'required|file|mimes:txt,csv',
        ]);

        $file = $request->file('keys_file');
        $lines = file($file->getRealPath(), FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        foreach ($lines as $line) {
            Key::create([
                'product_id'     => $request->product_id,
                'encrypted_key'  => trim($line), // auto-encrypt होगा mutator से
            ]);
        }

        return back()->with('success', 'Keys imported securely!');
    }
}
