<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Key;
use App\Models\User;
use App\Models\Order;
use Auth;
class AdminController extends Controller
{
    public function index()
    {
        $totalUsers = User::count();
        $totalOrders = Order::count();
        $totalRevenue = Order::sum('total_price');
        $availableKeys = Key::where('is_used', 0)->count();
        $recentOrders = Order::with(['user', 'product'])->latest()->take(5)->get();

        return view('admin.dashboard', compact(
            'totalUsers',
            'totalOrders',
            'totalRevenue',
            'availableKeys',
            'recentOrders'
        ));
    }


  public function key(Request $request)
{
   
    $query = Key::with(['product', 'user'])->orderBy('id', 'desc');

  
    if ($request->filled('search')) {
        $query->where('key_preview', 'like', '%' . $request->search . '%');
    }

 
    $keys = $query->get();

   
    $products = Product::all();

    return view('admin/key/index', compact('products', 'keys'));
}

public function keystore(Request $request)
{
    $request->validate([
        'product_id'     => 'required|exists:products,id',
        'encrypted_keys' => 'required|string',
        'duration'       => 'required|integer|min:1',
        'price'          => 'required|numeric|min:0',
    ]);

    // Split keys line by line
    $keys = preg_split('/\r\n|\r|\n/', trim($request->encrypted_keys));

    $savedCount = 0;

    foreach ($keys as $key) {
        $key = trim($key);
        if (!empty($key)) {
            Key::create([
                'product_id'    => $request->product_id,
                'encrypted_key' => $key,
                'duration'      => $request->duration,
                'price'         => $request->price,
            ]);
            $savedCount++; // sirf tab count kare jab save hua
        }
    }

    return redirect()->back()->with('success', $savedCount.' Key(s) saved successfully!');
}





}